//=============================================================================

/*:
 * @plugindesc Window.png未使用素材の横矢印を使うためのキット
 * @author LefTonbo
 *
 * @help
 * Window.png に含まれているウィンドウ横矢印はコアスクリプト上では
 * 未使用素材扱いであり、そのままでは使えません。
 * このプラグインはウィンドウ用の横矢印の表示を定義し、使用できるようにします。
 *
 * 開発者向けプラグインのため、単体では使用できません。
 *
 * == 使用方法 ==
 *
 * ウィンドウに対して leftArrowVisible、rightArrowVisible の真偽値を変更することで
 * 横矢印を表示または非表示することができます。
 * これらの変数の更新は updateArrows 関数上で行うと良いでしょう。
 *
 * このプラグインが使用されているかどうかは、次の変数がtrueかどうかでチェックできます。
 *   (Imported && Imported.LP_WindowLeftRightArrow)
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_WindowLeftRightArrow = true;

var LeftPlugin = LeftPlugin || {};

//=============================================================================

(function() {

//=============================================================================
// Window
//=============================================================================

var _Window_initialize = Window.prototype.initialize;
Window.prototype.initialize = function() {
  _Window_initialize.call(this);
  this.leftArrowVisible = false;
  this.rightArrowVisible = false;
}

var _Window_createAllParts = Window.prototype._createAllParts;
Window.prototype._createAllParts = function() {
  _Window_createAllParts.call(this);
  this._leftArrowSprite = new Sprite();
  this._rightArrowSprite = new Sprite();
  this.addChild(this._leftArrowSprite);
  this.addChild(this._rightArrowSprite);
};

var _Window_refreshArrows = Window.prototype._refreshArrows;
Window.prototype._refreshArrows = function() {
  _Window_refreshArrows.call(this);

  var w = this._width;
  var h = this._height;
  var p = 12;
  var q = p*2;
  var sx = 96+q;
  var sy = 0+q;

  this._leftArrowSprite.bitmap = this.windowskin;
  this._leftArrowSprite.anchor.x = 0.5;
  this._leftArrowSprite.anchor.y = 0.5;
  this._leftArrowSprite.setFrame(sx, sy + p, p, q);
  this._leftArrowSprite.move(p, h / 2);

  this._rightArrowSprite.bitmap = this.windowskin;
  this._rightArrowSprite.anchor.x = 0.5;
  this._rightArrowSprite.anchor.y = 0.5;
  this._rightArrowSprite.setFrame(sx + p + q, sy + p, p, q);
  this._rightArrowSprite.move(w - p, h / 2);
};

var _Window_updateArrows = Window.prototype._updateArrows;
Window.prototype._updateArrows = function() {
  _Window_updateArrows.call(this);
  this._leftArrowSprite.visible = this.isOpen() && this.leftArrowVisible;
  this._rightArrowSprite.visible = this.isOpen() && this.rightArrowVisible;
};

//=============================================================================

})();

// EOF